module.exports = function(grunt) {

	grunt.config('shell', {
		version: {
			command: 'git log -1 --pretty=format:%h',
					options: {
						callback: function log(err, stdout, stderr, cb) {
							var pkg = require('../package.json');
							grunt.file.write('app/version.json', JSON.stringify({
								version: pkg['version'],
								metaRevision: stdout,
								date: grunt.template.today()
							}));
							cb();
						}
					}
		}
	});

	grunt.loadNpmTasks('grunt-shell');

};
